
;---------------------------------------------------------------------------
;
; I/O Register definitions
;
;---------------------------------------------------------------------------
.equ SREG	=	$3f	; Status register, contains system flags
.equ SPL	=	$3d	; Stack pointer lo
.equ GIMSK	=	$3b	; General interrupt mask reg
.equ GIFR	=	$3a	; General interrupt flag reg
.equ TIMSK	=	$39	; Timer/Counter interrupt mask reg
.equ TIFR	=	$38	; Timer/Counter interrupt flag reg
.equ MCUCR	=	$35	; MCU general control reg
.equ TCCR0	=	$33	; Timer/Counter 0 control reg
.equ TCNT0	=	$32	; Timer/Counter 0 counting reg (8 bit)
.equ TCCR1A	=	$2f	; Timer/Counter 1 control reg A
.equ TCCR1B	=	$2e	; Timer/Counter 1 control reg B
.equ TCNT1H	=	$2d	; Timer/Counter 1 hi
.equ TCNT1L	=	$2c	; Timer/Counter 1 lo
.equ OCR1AH	=	$2b	; Output compare reg 1 hi
.equ OCR1AL	=	$2a	; Output compare reg 1 lo
.equ ICR1H	=	$25	; T/C 1 input capture reg hi
.equ ICR1L	=	$24	; T/C 1 input capture reg lo
.equ WDTCR	=	$21	; Watchdog timer control reg
.equ EEAR	=	$1e	; EEPROM address reg
.equ EEDR	=	$1d	; EEPROM data reg
.equ EECR	=	$1c	; EEPROM control reg
.equ PORTB	=	$18	; Port B data reg
.equ DDRB	=	$17	; Port B data direction reg
.equ PINB	=	$16	; Port B input pins
.equ PORTD	=	$12	; Port D data reg
.equ DDRD	=	$11	; Port D data direction reg
.equ PIND	=	$10	; Port D input pins
.equ UDR	=	$0c	; UART I/O data reg
.equ USR	=	$0b	; UART status reg
.equ UCR	=	$0a	; UART control reg
.equ UBRR	=	$09	; UART baud rate reg
.equ ACSR	=	$08	; Analog Comparitor control and status reg

;---------------------------------------------------------------------------
;
; Bit definitions
;
;---------------------------------------------------------------------------
; SREG - Status register
.equ I	=	7	; Global interrupt enable
.equ T	=	6	; bit copy storage
.equ H	=	5	; half carry flag
.equ S	=	4	; sign bit
.equ V	=	3	; two's complement overflow flag
.equ N	=	2	; Negative flag
.equ Z	=	1	; Zero flag
.equ C	=	0	; Carry flag

; GIMSK - General interrupt mask reg
.equ INT1	=	7	; External interrupt request 1 enable
.equ INT0	=	6	; External interrupt request 0 enable

; GIFR - General interrupt flag reg
.equ INTF1	=	7	; External interrupt 1 pending
.equ INTF0	=	6	; External interrupt 0 pending

; TIMSK - Timer/Counter interrupt mask reg
.equ TOIE1	=	7	; Timer/Counter 1 overflow int enable
.equ TOIE0	=	1	; Timer/Counter 0 overflow int enable

; TIFR - Timer/Counter interrupt flag reg
.equ TOV1	=	7	; Timer/Counter 1 overflow flag
.equ OCF1A	=	6	; Output Compare flag 1
.equ ICF1	=	3	; Input Capture flag 1
.equ TOV0	=	1	; Timer/Counter 0 overflow flag
.equ OCF0	=	0	; Output Compare flag 0

; MCUCR - MCU control reg
.equ SE	=	5	; Sleep Enable (=1 to enter sleep/powerdown mode)
.equ SM	=	4	; Sleep Mode select (idle / power down)
.equ ISC11	=	3	; External Interrupt 1 Sense Control bit 1
.equ ISC10	=	2	; External Interrupt 1 Sense Control bit 0
.equ ISC01	=	1	; External Interrupt 0 Sense Control bit 1
.equ ISC00	=	0	; External Interrupt 0 Sense Control bit 0

; TCCR0 - Timer/Counter 0 control reg
.equ CS02	=	2	; Timer/Counter0 prescaling source select bit 2
.equ CS01	=	1	; Timer/Counter0 prescaling source select bit 1
.equ CS00	=	0	; Timer/Counter0 prescaling source select bit 0

; TCCR1A - Timer/Counter 1 control reg A
.equ COM1A1	=	7	; Compare output mode bit 1
.equ COM1A0	=	6	; Compare output mode bit 0
.equ PWM1	=	0	; Pulse Width modulator enable

; TCCR1B - Timer/Counter 1 control reg B
.equ ICNC1	=	7	; Input capture 1 noise canceler
.equ ICES1	=	6	; Input capture 1 edge select
.equ CTC1	=	3	; Clear timer/counter 1 on compare match
.equ CS12	=	2	; Timer/Counter1 prescaling source select bit 2
.equ CS11	=	1	; Timer/Counter1 prescaling source select bit 1
.equ CS10	=	0	; Timer/Counter1 prescaling source select bit 0

; WDTCR - Watchdog timer control reg
.equ WDTTOE	=	4	; Watchdog Turn-Off Enable
.equ WDE	=	3	; Watchdog enable
.equ WDP2	=	2	; Watchdog timer prescaler select bit 2
.equ WDP1	=	1	; Watchdog timer prescaler select bit 1
.equ WDP0	=	0	; Watchdog timer prescaler select bit 0

; EECR - EEPROM control reg
.equ EEMWE	=	2	; EEPROM Master Write Enable
.equ EEWE	=	1	; EEPROM write enable
.equ EERE	=	0	; EEPROM Read enable

; USR - UART status reg
.equ RXC	=	7	; Receive complete
.equ TXC	=	6	; Transmission complete
.equ UDRE	=	5	; UART data reg empty
.equ FE	=	4	; Framing error
.equ OR	=	3	; Overrun error

; UCR - UART control reg
.equ RXCIE	=	7	; Receive complete interrupt enable
.equ TXCIE	=	6	; Transmit complete interrupt enable
.equ UDRIE	=	5	; UART data reg empty int enable
.equ RXEN	=	4	; Receive enable
.equ TXEN	=	3	; Transmit enable
.equ CHR9	=	2	; 9 bit character mode
.equ RXB8	=	1	; 9th bit received in 9-bit mode
.equ TXB8	=	0	; 9th bit to be transmitted in 9-bit mode

; PORTB - Port B Data reg
.equ PB7	=	7	; Port B bit 7
.equ PB6	=	6	; Port B bit 6
.equ PB5	=	5	; Port B bit 5
.equ PB4	=	4	; Port B bit 4
.equ PB3	=	3	; Port B bit 3
.equ PB2	=	2	; Port B bit 2
.equ PB1	=	1	; Port B bit 1
.equ PB0	=	0	; Port B bit 0
.equ AIN0	=	PB0	; Port B 0 alternate - Analog input 0
.equ AIN1	=	PB1	; Port B 1 alternate - Analog input 1
.equ MOSI	=	PB5	; Port B 5 alternate - Data input for mem downloading
.equ MISO	=	PB6	; Port B 6 alternate - Data output for mem uploading
.equ SCK	=	PB7	; Port B 7 alternate - Master clock during pgm

; DDRB - Port B data direction reg
.equ DDB7	=	7	; Data Direction reg B bit 7
.equ DDB6	=	6	; Data Direction reg B bit 6
.equ DDB5	=	5	; Data Direction reg B bit 5
.equ DDB4	=	4	; Data Direction reg B bit 4
.equ DDB3	=	3	; Data Direction reg B bit 3
.equ DDB2	=	2	; Data Direction reg B bit 2
.equ DDB1	=	1	; Data Direction reg B bit 1
.equ DDB0	=	0	; Data Direction reg B bit 0

; PINB - Port B input pins
.equ PINB7	=	7	; Port B Input bit 7
.equ PINB6	=	6	; Port B Input bit 6
.equ PINB5	=	5	; Port B Input bit 5
.equ PINB4	=	4	; Port B Input bit 4
.equ PINB3	=	3	; Port B Input bit 3
.equ PINB2	=	2	; Port B Input bit 2
.equ PINB1	=	1	; Port B Input bit 1
.equ PINB0	=	0	; Port B Input bit 0

; PORTD - Port D Data reg
.equ PD7	=	7	; Port D bit 7
.equ PD6	=	6	; Port D bit 6
.equ PD5	=	5	; Port D bit 5
.equ PD4	=	4	; Port D bit 4
.equ PD3	=	3	; Port D bit 3
.equ PD2	=	2	; Port D bit 2
.equ PD1	=	1	; Port D bit 1
.equ PD0	=	0	; Port D bit 0
.equ RXD	=	PD0	; PortD0 alternate - UART receive input
.equ TXD	=	PD1	; PortD1 alternate - UART transmit output
.equ XINT0	=	PD2	; PortD2 alternate - external interrupt 0
.equ XINT1	=	PD3	; PortD3 alternate - external interrupt 1
.equ T0		=	PD4	; PortD4 alternate - Timer/Counter0 input
.equ T1		=	PD5	; PortD5 alternate - Timer/Counter1 input
.equ ICP	=	PD6	; PortD6 alternate - Timer/Counter1 input capture pin
 
; DDRD - Port D data direction reg
.equ DDD7	=	7	; Data Direction reg D bit 7
.equ DDD6	=	6	; Data Direction reg D bit 6
.equ DDD5	=	5	; Data Direction reg D bit 5
.equ DDD4	=	4	; Data Direction reg D bit 4
.equ DDD3	=	3	; Data Direction reg D bit 3
.equ DDD2	=	2	; Data Direction reg D bit 2
.equ DDD1	=	1	; Data Direction reg D bit 1
.equ DDD0	=	0	; Data Direction reg D bit 0
 
; PIND - Port D input pins
.equ PIND7	=	7	; Port D Input bit 7
.equ PIND6	=	6	; Port D Input bit 6
.equ PIND5	=	5	; Port D Input bit 5
.equ PIND4	=	4	; Port D Input bit 4
.equ PIND3	=	3	; Port D Input bit 3
.equ PIND2	=	2	; Port D Input bit 2
.equ PIND1	=	1	; Port D Input bit 1
.equ PIND0	=	0	; Port D Input bit 0

; ACSR - Analog Comparitor control and status reg
.equ ACO	=	5	; Analog compare output
.equ ACI	=	4	; Analog comparitor interrupt flag
.equ ACIE	=	3	; Analog comparitor interrupt enable
.equ ACIC	=	2	; Analog comparitor input capture enable
.equ ACIS1	=	1	; Analog Comparitor interrupt mode select bit 1
.equ ACIS0	=	0	; Analog Comparitor interrupt mode select bit 0

;---------------------------------------------------------------------------
;
; Register definitions
;
;---------------------------------------------------------------------------
.def XL	=	r26	; lo byte of 16-bit index reg X
.def XH	=	r27	; hi byte of 16-bit index reg X
.def YL	=	r28	; lo byte of 16-bit index reg Y
.def YH	=	r29	; hi byte of 16-bit index reg Y
.def ZL	=	r30	; lo byte of 16-bit index reg Z
.def ZH	=	r31	; hi byte of 16-bit index reg Z
 
;---------------------------------------------------------------------------
; End of RAM
;
;---------------------------------------------------------------------------
.equ RAMSTART =	 $60	; first byte in RAM memory
.equ RAMEND =	$df	; last byte in RAM memory
