;Firmware for a DDR mat controller, using touchless switch technology.
;See http://sprite.student.utwente.nl/~jeroen/projects/ddr-mat/ for more
;info. This software is licensed under the GNU GPL. No implicit or other
;kind of warranty to the workings of this program is provided.

;If you use this sourcecode to implement something of your own, I'd love to hear
;about it. I can be reached at jeroen@ietsmet.nl .

.device AT90S2313

;includes
.include "at2313.inc"

;Port declarations

;PortB
.equ pad1	=	7
.equ pad2	=	6
.equ pad3	=	5
.equ pad4	=	4
.equ led3	=	3
.equ led3	=	2
.equ led2	=	1
.equ led1	=	0

.def temp	=	R16 	;The temp register
.def temp2	=	R17 	;Second temp register
.def temp3	=	R18
;Registers to store the running average
.def avg1	=	R19
.def avg2	=	R20
.def avg3	=	R21
.def avg4	=	R22
;Hits/misses counters
.def cnt1	=	R23
.def cnt2	=	R24
.def cnt3	=	R25
.def cnt4	=	R26
.def leds	=	r27

;De echte code
	.cseg			; switch to Code Segment
	.org	0		
	rjmp start		; reset vector
	reti			; External Int 0 not enabled
	reti			; External Int 1 not enabled
	reti			; Timer 1 Capture Int not enabled
	reti			; Timer 1 Compare match A Int not enabled
	reti			; Timer 1 Overflow Int not enabled
	reti			; Timer 0 Overflow Int not enabled
	reti			; UART ReceiveInt
	reti			; UART Date Reg Empty Int not enabled
	reti			; UART tx'ed Int Not enabled
	reti			; Anacomp interrupt Not enabled

start:
	ldi temp,RAMEND		; top of memory
	out SPL,temp		; init stack pointer
; - Setup Port B . . .
	ldi temp,0b001111	; Port B direction options
	out DDRB,temp		; Setup port direction
	ldi temp,0		; Port B output values
	out PORTB,temp		; Setup port control options
; - Setup Port D . . .
	ldi temp,0b1111		; Port D direction options
	out DDRD,temp		; Setup port direction
	ldi temp,$0		; Port D output values
	out PORTD,temp		; Setup port control options

vast:
;Zero out hit counters
	ldi cnt1,0
	ldi cnt2,0
	ldi cnt3,0
	ldi cnt4,0
	
	;Measure all pads 32 times.
	ldi temp3,32
loop1:
	rcall detect1
	rcall detect2
	rcall detect3
	rcall detect4
	dec temp3
	brne loop1
	
	
;If any of the pads had a miss more than 50% of the time, we can be 
;reasonably sure the pad is stepped on.
	ldi leds,0
	cpi cnt1,16
	brlo nieton1
	sbr leds,1
nieton1:
	cpi cnt2,16
	brlo nieton2
	sbr leds,2
nieton2:
	cpi cnt3,16
	brlo nieton3
	sbr leds,4
nieton3:
	cpi cnt4,16
	brlo nieton4
	sbr leds,8
nieton4:

;Send the detected values to the gameport, but invert them first. The button-
;inputs are active-low.
	com leds
	out portd,leds
	com leds	

	rjmp vast	


;The detectX-routines work like this:
;First of all the pin is grounded, so the pad will get flooded with electrons.
;If there is a foot above the pad, the electrons will induce a shift of 
;electrons in your body too. After waiting some time for this process to 
;complete (and, meanwhile, turning off the leds so they can't disturb the 
;measuring process) the pin is tristated and the time needed for the
;50K potmeter to pump all the electrons out again is measured. Because
;there's a bigger energy shift when your foot is above a pad, the time
;needed will be bigger then. This is compared to a running average, if the
;value is more than the average +  a few % then the detection counts as a hit
;and increases ctr1.

detect1:
	cbi portb,pad1
    	sbi ddrb,pad1
	rcall wacht
	cbi ddrb,pad1
	ldi temp,0
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp
	sbis pinb,pad1
	inc temp

	
	
	mov temp2,avg1
	lsr temp2
	lsr temp2
	lsr temp2
	sub avg1,temp2
	add avg1,temp

	mov temp2,avg1
	lsr temp2
	lsr temp2
	lsr temp2
	lsr temp2
	add temp2,avg1
	
	
;	ldi leds,0
	cp temp2,temp
	brge nietled1
	inc cnt1
;	ori leds,1
nietled1:
	ret



detect2:
	cbi portb,pad2
    	sbi ddrb,pad2
	rcall wacht
	cbi ddrb,pad2
	ldi temp,0
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp
	sbis pinb,pad2
	inc temp

	
	
	mov temp2,avg2
	lsr temp2
	lsr temp2
	lsr temp2
	sub avg2,temp2
	add avg2,temp

	mov temp2,avg2
	lsr temp2
	lsr temp2
	lsr temp2
	lsr temp2
	add temp2,avg2
	
	
	cp temp2,temp
	brge nietled2
	inc cnt2
;	ori leds,2
nietled2:
	ret



;This routine is called whenever there needs to be waited some time for
the electrons to flow in the pad.
wacht:
	ldi temp,0
	;Show led values
	andi leds,$f
	out portb,leds
wacht1:
	dec temp
	brne wacht1
	;Clear leds so they won't influence the measuring process
	out portb,temp
wacht2:
	dec temp
	brne wacht2
	ret


detect3:
	cbi portb,pad3
    	sbi ddrb,pad3
	rcall wacht
	cbi ddrb,pad3
	ldi temp,0
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp
	sbis pinb,pad3
	inc temp

	
	
	mov temp2,avg3
	lsr temp2
	lsr temp2
	lsr temp2
	sub avg3,temp2
	add avg3,temp

	mov temp2,avg3
	lsr temp2
	lsr temp2
	lsr temp2
	lsr temp2
	add temp2,avg3
	
	
	cp temp2,temp
	brge nietled3
	inc cnt3
;	ori leds,4
nietled3:
	ret


detect4:
	cbi portb,pad4
    	sbi ddrb,pad4
	rcall wacht
	cbi ddrb,pad4
	ldi temp,0
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp
	sbis pinb,pad4
	inc temp

	
	
	mov temp2,avg4
	lsr temp2
	lsr temp2
	lsr temp2
	sub avg4,temp2
	add avg4,temp

	mov temp2,avg4
	lsr temp2
	lsr temp2
	lsr temp2
	lsr temp2
	add temp2,avg4
	
	
	cp temp2,temp
	brge nietled4
	inc cnt4
;	ori leds,8
nietled4:
	ret

